#include "Pipe.h"



Pipe::Pipe()
{
	setCollider(true);
}


Pipe::~Pipe()
{
}

void Pipe::create(SpriteSize size)
{
	spriteSize = size;
	spriteType = SpriteType::PipeSprite;

	switch (spriteSize)
	{
		case SpriteSize::Small:
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Pipe/smallPipe.png");	//Load the small texture
			setSize(sf::Vector2f(110, 110));	//Set the small size
			setCollisionBox(sf::FloatRect(0, 0, 110, 110));	//Set the pipe's collision box for small
			break;

		case SpriteSize::Medium:
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Pipe/mediumPipe.png");	//Load the medium texture
			setSize(sf::Vector2f(110, 170));	//Set the medium size
			setCollisionBox(sf::FloatRect(0, 0, 110, 170));	//Set the pipe's collision box for medium
			break;

		case SpriteSize::Big:
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Pipe/bigPipe.png");	//Load the big texture
			setSize(sf::Vector2f(110, 225));	//Set the big size
			setCollisionBox(sf::FloatRect(0, 0, 110, 225));	//Set the pipe's collision box for big
			break;
	}

	setTexture(&spriteTexture);
}

void Pipe::handleCollision(MySprite* sprite, float dt)
{
	if (sprite->getPosition().y + (sprite->getSize().y * 0.70) <= getPosition().y && sprite->getVelocity().y >= 0.f)	//If we touch the top of the pipe and we're falling
	{
		//Foot collision
		if (sprite->getAirbourne())	//If we're in the air
		{
			sprite->setAirbourne(false);	//We have our feet on the block so we're no longer airbourne
			sprite->setVelocity(0, 0);	//We kill all of our velocity
		}

		else    //Not in the air
		{
			sprite->setVelocity(sprite->getVelocity().x, 0);	//We kill our y velocity but keep the x velocity to allow the player to move horizontally across the block
		}

		sprite->setPosition(sprite->getPosition().x, getPosition().y - sprite->getSize().y);
	}

	else
	{
		//We MUST have a side collision
		if (sprite->getPosition().x + sprite->getSize().x >= getPosition().x + (getSize().x / 2))	//Right side collision
		{
			sprite->setPosition(getPosition().x + getSize().x + 2.f, sprite->getPosition().y);	//We set the sprite's x back to the edge's x coordinate plus a 2 pixel offset to prevent clipping
		}

		else    //Left side collision
		{
			sprite->setPosition(getPosition().x - sprite->getSize().x - 2.f, sprite->getPosition().y);	//We set the sprite's x back to the edge's x coordinate plus a 2 pixel offset to prevent clipping
		}
	}
}